﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using VeteransAffairs.Registries.BusinessManager;

public partial class RegistryReport : System.Web.UI.MasterPage
{
    public delegate void MasterPageMenuClickHandler(object sender, MenuEventArgs e);
    public event MasterPageMenuClickHandler MenuClick;

    private string GetContextSensitiveHelpURL()
    {
        return "~/help/" + Page.Page.ToString().Substring(4).Replace("_aspx", ".html");
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        // Sets the correct URL for context sensitive help, based on content page
        horizMenu.Items[4].NavigateUrl = GetContextSensitiveHelpURL();

        //sets onfocus event to all apropriate controls on the page.
        if (!IsPostBack)
            HookOnFocus(this.Page as Control);


        MenuBuilder.SetMyTasksLink(horizMenu);
        MenuBuilder.SetPatientLink(horizMenu);

        //lblCurrentUser.Text = Page.User.Identity.Name.ToString(); // "jhagerty";
        //lblCurrentDateTime.Text = DateTime.Now.ToString();
    }
    protected void Menu2_MenuItemClick(object sender, MenuEventArgs e)
    {
        if (MenuClick != null)
        {
            MenuClick(sender, e);
        }
    }
    /// <summary>
    /// This function goes recursively all child controls and sets 
    /// onfocus attribute if the control has one of defined types.
    /// </summary>
    /// <param name="CurrentControl">the control to hook.</param>
    private void HookOnFocus(Control CurrentControl)
    {
        //checks if control is one of TextBox, DropDownList, ListBox or Button

        if ((CurrentControl is TextBox) ||
            (CurrentControl is DropDownList) ||
            (CurrentControl is ListBox) ||
            (CurrentControl is CheckBoxList) ||
            (CurrentControl is Button))
            //adds a script which saves active control on receiving focus 
            //in the hidden field __LASTFOCUS.

            //Fortify errors on this line (CurrentControl as WebControl).Attributes.Add(
            ((WebControl)CurrentControl).Attributes.Add(
               "onfocus",
               "try{document.getElementById('__LASTFOCUS').value=this.id} catch(e) {}"
            );
        //checks if the control has children

        if (CurrentControl.HasControls())
            //if yes do them all recursively

            foreach (Control CurrentChildControl in CurrentControl.Controls)
                HookOnFocus(CurrentChildControl);
    }
    /// <summary>
    /// This script sets a focus to the control with a name to which
    /// REQUEST_LASTFOCUS was replaced. Setting focus heppens after the page
    /// (or update panel) was rendered. To delay setting focus the function
    /// window.setTimeout() will be used.
    /// </summary>
    private const string SCRIPT_DOFOCUS =
        @"window.setTimeout('DoFocus()', 1);
        function DoFocus()
        {
            try {
                document.getElementById('REQUEST_LASTFOCUS').focus();
            } catch (ex) {}
        }";
}
